#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;

gunFightHud(){
	self maps\mp\gametypes\_gamelogic::freegameplayhudelems();
	//removes default hud to improve stability

	self thread createPerkIcons();

	if(!isDefined(self.WinStatus))
		self.WinStatus = self createFontString("default", 1.9);
	self.WinStatus setPoint( "TOP CENTER", "TOP CENTER", 0, 17);
	self.WinStatus.glowColor = ((0/255),(171/255),(255/255));
	self.WinStatus.glowAlpha = 0.3;
	self.WinStatus.alpha = 1;
	self.WinStatus.HideWhenInMenu = true;

	if(!isDefined(self.gameInfo))
		self.gameInfo = self createFontString("default", 1);
	self.gameInfo.color=((255/255),(255/255),(255/255));
	self.gameInfo setPoint("BOTTOMLEFT", "BOTTOMLEFT", 60, -20);
	self.gameInfo.glowColor = ((0/255),(0/255),(0/255));
	self.gameInfo.glowAlpha = 0.3;
	self.gameInfo.HideWhenInMenu = true;
	
	while(!level.weaponsSet)
		wait 0.1;

	if(level.loudout["special"]["grenade"] == "specialty_tacticalinsertion")
		self.gameInfo thread destroyOnOvertime();
	else
		self.gameInfo thread destroyOnEndGame();

	self thread HealthBars();
	self thread waittillDestroy();
}

showFlagStatus(pos){
	if(self.CaptureBarText.alpha == 1)
		return;
	self.CaptureBar.alpha = 1;
	self.CaptureBar.bar.alpha = 1;
	self.CaptureBarText.alpha = 1;
	while(self.CaptureBarText.alpha == 1){
		if(Distance(pos, self.origin) > 100){
			self.CaptureBar.alpha = 0;
			self.CaptureBar.bar.alpha = 0;
			self.CaptureBarText.alpha = 0;
			level.TeamOnFlag[self.team] = 0;
		}
		wait 0.1;
	}
}


doPrintFx(text){
	self notify("spam_protection");
	self endon("spam_protection");
	self fadeovertime(0.05);
	self.alpha = 1;
	self ChangeFontScaleOverTime( 0.1 );
	self.fontScale = 1.5;
	self setText(text);
	wait 0.1;
	self ChangeFontScaleOverTime( 0.1 );
	self.fontScale = 1.25;
	wait 1;
	self fadeovertime(1);
	self.alpha = 0;
}

HealthBars()
{
	self endon("disconnect");
	if(!isDefined(self.HealthBar1))
		self.HealthBar1 = createPrimaryProgressBar();
	if(!isDefined(self.HealthBarText1))
		self.HealthBarText1 = self createFontString( "objective", 1.1 );
	if(!isDefined(self.HealthBar2))
		self.HealthBar2 = createPrimaryProgressBar();
	if(!isDefined(self.HealthBarText2))
		self.HealthBarText2 = self createFontString( "objective", 1.1 );

	self.HealthBar1 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);
	self.HealthBar2 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);

	self.HealthBarText1 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);
	self.HealthBarText2 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);
	
	self.HealthBar1 setshader( "progress_bar_bg", 120, 9 );
	self.HealthBar2 setshader( "progress_bar_bg", 120, 9 );

	self.HealthBar1.color=((255/255),(255/255),(255/255));
	self.HealthBar2.color=((255/255),(255/255),(255/255));

	self.HealthBar1.alpha=0.3;
	self.HealthBar2.alpha=0.3;

	self.HealthBarText1.sort = 99;
	self.HealthBarText2.sort = 99;

	offset = -210;
	self.HealthBarText1.y = 14;
	self.HealthBarText2.y = 14;
	self.HealthBar1.y = 25;
	self.HealthBar2.y = 25;
	self.HealthBar1.bar.y = 25;
	self.HealthBar2.bar.y = 25;
	self.HealthBar1.sort = 99;
	self.HealthBar2.sort = 99;
	self.HealthBar1.bar.sort = 101;
	self.HealthBar2.bar.sort = 101;

	if(!isDefined(self.CutureHud1))
		self.CutureHud1 = createprimaryprogressbar();
	if(!isDefined(self.CutureHud2))
		self.CutureHud2 = createprimaryprogressbar();
	self.CutureHud1 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);
	self.CutureHud2 setPoint( "TOP CENTER", "TOP CENTER", 0, 0);
	self.CutureHud1 setshader( "progress_bar_bg", 120, 2 );
	self.CutureHud2 setshader( "progress_bar_bg", 120, 2 );
	self.CutureHud2.sort = 110;
	self.CutureHud1.sort = 110;
	self.CutureHud2.bar.sort = 111;
	self.CutureHud1.bar.sort = 111;
	self.CutureHud1.y = 32;
	self.CutureHud2.y = 32;
	self.CutureHud1.bar.y = 32;
	self.CutureHud2.bar.y = 32;
	self.CutureHud1.alpha = 1;
	self.CutureHud2.alpha = 1;
	self.CutureHud1.height = 2;
	self.CutureHud2.height = 2;
	self.CutureHud1.bar.color=((235/255),(204/255),(53/255));
	self.CutureHud2.bar.color=((235/255),(204/255),(53/255));
	self.CutureHud1.bar.alpha = 0;
	self.CutureHud2.bar.alpha = 0;

	self.CutureHud1.HideWhenInMenu = true;
	self.CutureHud2.HideWhenInMenu = true;
	self.CutureHud1.bar.HideWhenInMenu = true;
	self.CutureHud2.bar.HideWhenInMenu = true;

	/*if(!isDefined(self.CaptureBar))
		self.CaptureBar = createPrimaryProgressBar( 30 );
	if(!isDefined(self.CaptureBarText))
		self.CaptureBarText = createPrimaryProgressBarText();
	self.CaptureBarText setText("Capturing");
	self.CaptureBar.bar.x = -60;
	self.CaptureBar.x = 0;
	self.CaptureBarText.alpha = 0;
	self.CaptureBarText.alignX = "center";
	self.CaptureBarText.alignY = "middle";
	self.CaptureBarText.horzAlign = "center";
	self.CaptureBarText.vertAlign = "middle";
	self.CaptureBar.alpha = 0;
	self.CaptureBar.bar.alpha = 0;*/

	/*if(!isDefined(self.HealthIcon1))
		self.HealthIcon1 = NewClientHudElem( self );
	self.HealthIcon1.alignX = "center";
	self.HealthIcon1.alignY = "middle";
	self.HealthIcon1.horzAlign = "center";
	self.HealthIcon1.vertAlign = "middle";
	self.HealthIcon1.x = 175;
	self.HealthIcon1.y = -222;
	self.HealthIcon1 setIconShader( "waypoint_revive" );
	self.HealthIcon1 setIconSize( 13, 13 );
	self.HealthIcon1.alpha = 1;	

	if(!isDefined(self.HealthIcon2))
		self.HealthIcon2 = NewClientHudElem( self );
	self.HealthIcon2.alignX = "center";
	self.HealthIcon2.alignY = "middle";
	self.HealthIcon2.horzAlign = "center";
	self.HealthIcon2.vertAlign = "middle";
	self.HealthIcon2.x = -175;
	self.HealthIcon2.y = -222;
	self.HealthIcon2 setIconShader( "waypoint_revive" );
	self.HealthIcon2 setIconSize( 13, 13 );
	self.HealthIcon2.alpha = 1;	

	self.HealthIcon1.HideWhenInMenu = true;
	self.HealthIcon2.HideWhenInMenu = true;*/


	self.HealthBar1.HideWhenInMenu = true;
	self.HealthBarText1.HideWhenInMenu = true;
	self.HealthBar2.HideWhenInMenu = true;
	self.HealthBarText2.HideWhenInMenu = true;
	self.HealthBar1.bar.HideWhenInMenu = true;
	self.HealthBar2.bar.HideWhenInMenu = true;

	oldAxisHealth = 0;
	oldAxisMaxHealth = 0;
	oldAlliesHealth = 0;
	oldAlliesMaxHealth = 0;
	CaptureStatusaxis = 0;
	CaptureStatusallies = 0;

	self thread setHealthBarTeams();
	self.HealthBar1 updateBar(1/1);
	self.HealthBar2 updateBar(1/1);
	//while(level.matchBeginTimer > 0)//Add this back if unstable
	//	wait 0.1;

	//self thread slowUpdateHealthInt();
	

	while(self.updateGameHud){

		self.gameInfo setSafeText("score limit: "+(getdvarint("scr_gf_winlimit")));

		if(self.oldTeam != self.team){
			self.oldTeam = self.team;
			self thread setHealthBarTeams();
		}
		if(level.matchBeginTimer <= 0){
			if(level.AxisHealth != oldAxisHealth || level.AxisMaxHealth != oldAxisMaxHealth ){
				oldAxisHealth = level.AxisHealth;
				oldAxisMaxHealth = level.AxisMaxHealth;
				self.HealthBar2 updateBar(level.AxisHealth/level.AxisMaxHealth);
			}
			if(level.AlliesHealth != oldAlliesHealth || level.AlliesMaxHealth != oldAlliesMaxHealth ){
				oldAlliesHealth = level.AlliesHealth;
				oldAlliesMaxHealth = level.AlliesMaxHealth;
				self.HealthBar1 updateBar(level.AlliesHealth/level.AlliesMaxHealth);
			}
		}

		if(getdvar("gf_healthmode") == "percent"){
			if(isDefined(self.HealthBarText1) && isDefined(self.HealthBarText2)){
				self.HealthBarText1 setSafeValue(int((level.AlliesHealth/level.AlliesMaxHealth)*100));
				self.HealthBarText2 setSafeValue(int((level.AxisHealth/level.AxisMaxHealth)*100));
			}

			if(self.team == "axis"){
				if(int((level.AxisHealth/level.AxisMaxHealth)*100) < int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = false;
					self.WinStatus setSafeText("losing");
					self.WinStatus.glowColor = ((255/255),(43/255),(0/255));
				}	
				else if(int((level.AxisHealth/level.AxisMaxHealth)*100) > int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = true;
					self.WinStatus setSafeText("winning");
					self.WinStatus.glowColor = ((0/255),(171/255),(255/255));
				}	
				else if(int((level.AxisHealth/level.AxisMaxHealth)*100) == int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = false;
					self.WinStatus setSafeText("tied");
					self.WinStatus.glowColor = ((255/255),(255/255),(0/255));
				}
			}
			if(self.team == "allies"){
				if(int((level.AxisHealth/level.AxisMaxHealth)*100) < int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = true;
					self.WinStatus setSafeText("winning");
					self.WinStatus.glowColor = ((0/255),(171/255),(255/255));
				}
				else if(int((level.AxisHealth/level.AxisMaxHealth)*100) > int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = false;
					self.WinStatus setSafeText("losing");
					self.WinStatus.glowColor = ((255/255),(43/255),(0/255));
				}
				else if(int((level.AxisHealth/level.AxisMaxHealth)*100) == int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
					self.isWinning = false;
					self.WinStatus setSafeText("tied");
					self.WinStatus.glowColor = ((255/255),(255/255),(0/255));
				}
			}
		}
		else{
			if(isDefined(self.HealthBarText1) && isDefined(self.HealthBarText2)){
				self.HealthBarText1 setSafeValue(level.AlliesHealth);
				self.HealthBarText2 setSafeValue(level.AxisHealth);
			}
			if(self.team == "axis"){
				if(level.AxisHealth < level.AlliesHealth){
					//self.isWinning = false;
					self thread setWinStatus(false);
					self.WinStatus setSafeText("losing");
					self.WinStatus.glowColor = ((255/255),(43/255),(0/255));
				}	
				else if(level.AxisHealth > level.AlliesHealth){
					//self.isWinning = true;
					self thread setWinStatus(true);
					self.WinStatus setSafeText("winning");
					self.WinStatus.glowColor = ((0/255),(171/255),(255/255));
				}	
				else if(level.AxisHealth == level.AlliesHealth){
					//self.isWinning = false;
					self thread setWinStatus(false);
					self.WinStatus setSafeText("tied");
					self.WinStatus.glowColor = ((0/255),(0/255),(0/255));
				}
			}
			if(self.team == "allies"){
				if(level.AxisHealth < level.AlliesHealth){
					//self.isWinning = true;
					self thread setWinStatus(true);
					self.WinStatus setSafeText("winning");
					self.WinStatus.glowColor = ((0/255),(171/255),(255/255));
				}
				else if(level.AxisHealth > level.AlliesHealth){
					//self.isWinning = false;
					self thread setWinStatus(false);
					self.WinStatus setSafeText("losing");
					self.WinStatus.glowColor = ((255/255),(43/255),(0/255));
				}
				else if(level.AxisHealth == level.AlliesHealth){
					//self.isWinning = false;
					self thread setWinStatus(false);
					self.WinStatus setSafeText("tied");
					self.WinStatus.glowColor = ((0/255),(0/255),(0/255));
				}
			}
		}

	if(level.AlliesHealth == 0)
		self.HealthBar1.bar.alpha = 0;
	else if(level.AxisHealth == 0)
		self.HealthBar2.bar.alpha = 0;
	else{
		self.HealthBar1.bar.alpha = 1;
		self.HealthBar2.bar.alpha = 1;
	}
		if(level.CaptureStatus["axis"] <= 100 && level.CaptureStatus["allies"] <= 100){
			if(level.CaptureStatus["axis"] == 0){
				self.CutureHud1.bar.alpha = 0;
			}
			else{
				self.CutureHud1.bar.alpha = 1;	
				if(level.CaptureStatus["axis"] != CaptureStatusaxis){
					CaptureStatusaxis = level.CaptureStatus["axis"];
					self.CutureHud1 updateBar(roundDown(level.CaptureStatus["axis"])/100);
				}
			}
			if(level.CaptureStatus["allies"] == 0){
				self.CutureHud2.bar.alpha = 0;
			}
			else{
				self.CutureHud2.bar.alpha = 1;
				if(level.CaptureStatus["allies"] != CaptureStatusallies){
					CaptureStatusallies = level.CaptureStatus["allies"];
					self.CutureHud2 updateBar(roundDown(level.CaptureStatus["allies"])/100);
				}
			}
		}
		wait 0.025;
	}
}

roundDown( floatVal ) 
{
	if(int( floatVal) != floatVal)
		return int( floatVal-1 ); 
	else 
		return int( floatVal );
} 

slowUpdateHealthInt(){
	while(self.updateGameHud){
		if(isDefined(self.HealthBarText1) && isDefined(self.HealthBarText2)){
			self.HealthBarText1 setSafeValue(level.AlliesHealth);
			self.HealthBarText2 setSafeValue(level.AxisHealth);
		}
		wait 1;
	}
}

createPlayerFlagHud(){
	self.OvertimeText = self createfontstring("default", 1.2);
	self.OvertimeText setPoint( "TOP CENTER", "TOP CENTER", 0, 40);
	self.OvertimeText.color = ((255/255),(255/255),(0/255));
	self.OvertimeText.alpha = 1;
	self.OvertimeText.glowColor = ((0/255),(0/255),(0/255));
	self.OvertimeText.glowAlpha = 0.3;
	self.OvertimeText setSafeText("Overtime");
	self.OvertimeText thread destroyOnEndGame();
}

setSafeText(text)
{
	if(text != self.SafeText && isDefined(self))
	{
		self setText(text);
		self.SafeText = text;
	}
}

setSafeText_debug(owner,text)
{
	//iPrintLn(text+" isDefined() == "+isDefined(self));
	if(text != self.SafeText && isDefined(self))
	{
		self setText(text);
		self.SafeText = text;
		owner.healthUpdateCount++;
		owner iPrintLnBold(owner.healthUpdateCount);
		owner iPrintLn(text);
	}
}

setSafeValue(text)
{
	//iPrintLn(text+" isDefined() == "+isDefined(self));
	if(text != self.SafeValue && isDefined(self))
	{
		self setValue(text);
		self.SafeValue = text;
	}
}

setWinStatus(var_0){
	if(self.isWinning != var_0){
		self.isWinning = var_0;
	}
}

setHealthBarTeams(){
	if(self.team == "allies"){
		self.HealthBar1.bar.x = -180;
		self.HealthBar1.x = -120;
		self.HealthBar1.bar.color=level.teamColor["friendly"];
		self.HealthBar1.color=level.teamColor["friendly"];
		self.HealthIcon2.color=level.teamColor["friendly"];
		self.HealthBarText1.color=level.teamColor["friendly"];
		self.HealthBarText1.x=-170;
		self.HealthBarText1.glowcolor=level.teamColor["friendly"];
		self.HealthBarText1.glowAlpha=0.3;

		self.HealthBar2.bar.x = 60;
		self.HealthBar2.x = 120;
		self.HealthBar2.bar.color=level.teamColor["enemy"];
		self.HealthBar2.color=level.teamColor["enemy"];
		self.HealthIcon1.color=level.teamColor["enemy"];
		self.HealthBarText2.color=level.teamColor["enemy"];
		self.HealthBarText2.x=170;
		self.HealthBarText2.glowcolor=level.teamColor["enemy"];
		self.HealthBarText2.glowAlpha=0.3;

		self.CutureHud1.bar.x = 60;
		self.CutureHud1.x = 120;

		self.CutureHud2.bar.x = -180;
		self.CutureHud2.x = -120;
	}

	if(self.team == "axis"){
		self.HealthBar1.bar.x = 60;
		self.HealthBar1.x = 120;
		self.HealthBar1.bar.color=level.teamColor["enemy"];
		self.HealthBar1.color=level.teamColor["enemy"];
		self.HealthIcon1.color=level.teamColor["enemy"];
		self.HealthBarText1.color=level.teamColor["enemy"];
		self.HealthBarText1.x=170;
		self.HealthBarText1.glowcolor=level.teamColor["enemy"];
		self.HealthBarText1.glowAlpha=0.3;

		self.HealthBar2.bar.x = -180;
		self.HealthBar2.x = -120;
		self.HealthBar2.bar.color=level.teamColor["friendly"];
		self.HealthBar2.color=level.teamColor["friendly"];
		self.HealthIcon2.color=level.teamColor["friendly"];
		self.HealthBarText2.color=level.teamColor["friendly"];
		self.HealthBarText2.x=-170;
		self.HealthBarText2.glowcolor=level.teamColor["friendly"];
		self.HealthBarText2.glowAlpha=0.3;

		self.CutureHud1.bar.x = -180;
		self.CutureHud1.x = -120;

		self.CutureHud2.bar.x = 60;
		self.CutureHud2.x = 120;
	}
}

createPerkIcons(){
	offset = 72;
	if(!isDefined(self.perkIcon)){
		self.perkIcon = [];
		for(i=0;i<3;i++){
			self.perkIcon[i] = self createFontString( "default", 2 );
			self.perkIcon[i] setPoint( "BOTTOM RIGHT", "BOTTOM RIGHT", -8, (-12-offset));
			self.perkIcon[i].HideWhenInMenu = true;
			self.perkIcon[i].foreground = true;
			self.perkIcon[i] setIconSize( 30, 30 );
			self.perkIcon[i].alpha = 0;
			offset += 23;
		}
	}
	self.perkIcon[0] setIconShader( level.loudout["perk"]["3"] );
	self.perkIcon[1] setIconShader( level.loudout["perk"]["2"] );
	self.perkIcon[2] setIconShader( level.loudout["perk"]["1"] );
	self.perkIcon[0] thread destroyOnOvertime();
	self.perkIcon[1] thread destroyOnOvertime();
	self.perkIcon[2] thread destroyOnOvertime();

	for(i=0;i<3;i++){
		self.perkIcon[i] fadeOverTime( 2.00 );
		self.perkIcon[i].alpha = 1;
		self.perkIcon[i].archived = false;
	}
}

destroyOnOvertime(){
	level waittill_any("begin_overtime", "overtime_over", "game_ended", "showing_final_killcam", "game_cleanup");
	if ( isdefined( self ) )
		self destroy();
}

destroyOnEndGame(){
	level waittill_any("overtime_over", "game_ended", "showing_final_killcam", "game_cleanup");
	if ( isdefined( self ) )
		self destroy();
}

createStimIcon(){
	if(!isdefined(self.Tac))
	{
		self.Tac = self createFontString( "default", 2 );
		self.Tac setIconSize( 20, 20 );
		self.Tac setIconShader( "waypoint_revive" );
		//self.Tac = createIcon( "waypoint_revive", 20, 20 );
		self.Tac.color=((47/255),(215/255),(52/255));
		self.Tac setPoint( "BOTTOM RIGHT", "BOTTOM RIGHT", -76, -30);
		self.Tac.HideWhenInMenu = true;
		self.Tac.sort = 10001;
		self.Tac.alpha = 0;
		self.Tac thread destroyOnEndGame();
		//self.Tac2 = createIcon( "waypoint_revive", 20, 20 );
		self.Tac2.color=((47/255),(215/255),(52/255));
		self.Tac2 setPoint( "BOTTOM RIGHT", "BOTTOM RIGHT", -78, -28);
		self.Tac2.HideWhenInMenu = true;
		self.Tac2.sort = 10000;
		self.Tac2.alpha = 0;
		self.Tac2 thread destroyOnEndGame();
	}
}

waittillDestroy(){
    self waittill_any("showing_final_killcam", "disconnect", "map_voting", "death", "overtime_over");
	wait 0.25;
	if(game["state"] == "postgame")
		wait 3;
	self thread deleteGameHud();
}

deleteGameHud(){
	if ( isdefined( self.lowermessage ) )
        self.lowermessage destroyelem();
	if ( isdefined( self.gameInfo ) )
        self.gameInfo destroy();
    if ( isdefined( self.WinStatus ) )
		self.WinStatus destroy();
	if ( isdefined( self.OvertimeText ) )
		self.OvertimeText destroy();
	if ( isdefined( self.HealthBar1 ) )
		self.HealthBar1 destroyElem();
	if ( isdefined( self.HealthBar2 ) )
		self.HealthBar2 destroyElem();
	if ( isdefined( self.HealthBarText1 ) )
		self.HealthBarText1 destroy();
	if ( isdefined( self.HealthBarText2 ) )
		self.HealthBarText2 destroy();
	if ( isdefined( self.HealthIcon1 ) )
		self.HealthIcon1 destroy();
	if ( isdefined( self.HealthIcon2 ) )
		self.HealthIcon2 destroy();
	if ( isdefined( self.CutureHud1 ) )
		self.CutureHud1 destroyElem();
	if ( isdefined( self.CutureHud2 ) )
		self.CutureHud2 destroyElem();
	if ( isdefined( self.credits ) )
		self.credits destroy();
	if ( isdefined( self.CaptureBar ) )
		self.CaptureBar destroyElem();
	if ( isdefined( self.CaptureBarText ) )
		self.CaptureBarText destroyElem();
	if ( isdefined( self.Tac ) )
		self.Tac destroy();
	if ( isdefined( self.Tac2 ) )
		self.Tac2 destroy();
}

getMapName(){
	level.gfmaps = [];

	level.gfmaps["mp_hardhat"] = [];
	level.gfmaps["mp_hardhat"]["localised_name"] = "Hardhat (MW3)";
	level.gfmaps["mp_hardhat"]["zone_name"] = "mp_hardhat";

	level.gfmaps["mp_dome"] = [];
	level.gfmaps["mp_dome"]["localised_name"] = "Dome (MW3)";
	level.gfmaps["mp_dome"]["zone_name"] = "mp_dome";

	level.gfmaps["mp_alpha"] = [];
	level.gfmaps["mp_alpha"]["localised_name"] = "Lockdown (MW3)";
	level.gfmaps["mp_alpha"]["zone_name"] = "mp_alpha";

	level.gfmaps["mp_bravo"] = [];
	level.gfmaps["mp_bravo"]["localised_name"] = "Mission (MW3)";
	level.gfmaps["mp_bravo"]["zone_name"] = "mp_bravo";

	level.gfmaps["mp_plaza2"] = [];
	level.gfmaps["mp_plaza2"]["localised_name"] = "Arkaden (MW3)";
	level.gfmaps["mp_plaza2"]["zone_name"] = "mp_plaza2";

	level.gfmaps["mp_seatown"] = [];
	level.gfmaps["mp_seatown"]["localised_name"] = "Seatown (MW3)";
	level.gfmaps["mp_seatown"]["zone_name"] = "mp_seatown";

	level.gfmaps["mp_underground"] = [];
	level.gfmaps["mp_underground"]["localised_name"] = "Underground (MW3)";
	level.gfmaps["mp_underground"]["zone_name"] = "mp_underground";
	
	level.gfmaps["mp_village"] = [];
	level.gfmaps["mp_village"]["localised_name"] = "Village (MW3)";
	level.gfmaps["mp_village"]["zone_name"] = "mp_village";

	level.gfmaps["mp_sfs_minecraft"] = [];
	level.gfmaps["mp_sfs_minecraft"]["localised_name"] = "Minecraft SFS (Custom)";
	level.gfmaps["mp_sfs_minecraft"]["zone_name"] = "mp_sfs_minecraft";

	level.gfmaps["mp_c4s_minecraft"] = [];
	level.gfmaps["mp_c4s_minecraft"]["localised_name"] = "Minecraft C4 (Custom)";
	level.gfmaps["mp_c4s_minecraft"]["zone_name"] = "mp_c4s_minecraft";

	level.gfmaps["mp_waw_castle"] = [];
	level.gfmaps["mp_waw_castle"]["localised_name"] = "Castle (World At War)";
	level.gfmaps["mp_waw_castle"]["zone_name"] = "mp_waw_castle";

	level.gfmaps["mp_sharqi_day"] = [];
	level.gfmaps["mp_sharqi_day"]["localised_name"] = "Sharqi Day (Custom)";
	level.gfmaps["mp_sharqi_day"]["zone_name"] = "mp_sharqi_day";

	level.gfmaps["mp_rasalem"] = [];
	level.gfmaps["mp_rasalem"]["localised_name"] = "Rasalem (Custom)";
	level.gfmaps["mp_rasalem"]["zone_name"] = "mp_rasalem";

	level.gfmaps["mp_pipeline"] = [];
	level.gfmaps["mp_pipeline"]["localised_name"] = "Pipeline (COD4)";
	level.gfmaps["mp_pipeline"]["zone_name"] = "mp_pipeline";

	level.gfmaps["mp_paris"] = [];
	level.gfmaps["mp_paris"]["localised_name"] = "Resistance (MW3)";
	level.gfmaps["mp_paris"]["zone_name"] = "mp_paris";

	level.gfmaps["mp_mw2_rust"] = [];
	level.gfmaps["mp_mw2_rust"]["localised_name"] = "Rust 2 (Custom)";
	level.gfmaps["mp_mw2_rust"]["zone_name"] = "mp_mw2_rust";

	level.gfmaps["mp_luna"] = [];
	level.gfmaps["mp_luna"]["localised_name"] = "Luna (Custom)";
	level.gfmaps["mp_luna"]["zone_name"] = "mp_luna";

	level.gfmaps["mp_lost"] = [];
	level.gfmaps["mp_lost"]["localised_name"] = "Lost (Custom)";
	level.gfmaps["mp_lost"]["zone_name"] = "mp_lost";

	level.gfmaps["mp_farm"] = [];
	level.gfmaps["mp_farm"]["localised_name"] = "Downpour(COD4)";
	level.gfmaps["mp_farm"]["zone_name"] = "mp_farm";

	level.gfmaps["mp_creek"] = [];
	level.gfmaps["mp_creek"]["localised_name"] = "Creek (COD4)";
	level.gfmaps["mp_creek"]["zone_name"] = "mp_creek";

	level.gfmaps["mp_countdown"] = [];
	level.gfmaps["mp_countdown"]["localised_name"] = "Countdown (MW2)";
	level.gfmaps["mp_countdown"]["zone_name"] = "mp_countdown";

	level.gfmaps["mp_convoy"] = [];
	level.gfmaps["mp_convoy"]["localised_name"] = "Convoy (Black Ops)";
	level.gfmaps["mp_convoy"]["zone_name"] = "mp_convoy";

	level.gfmaps["mp_bo2standoff"] = [];
	level.gfmaps["mp_bo2standoff"]["localised_name"] = "Standoff (BO2)";
	level.gfmaps["mp_bo2standoff"]["zone_name"] = "mp_bo2standoff";

	level.gfmaps["mp_bo2carrier"] = [];
	level.gfmaps["mp_bo2carrier"]["localised_name"] = "Carrier (BO2)";
	level.gfmaps["mp_bo2carrier"]["zone_name"] = "mp_bo2carrier";

	level.gfmaps["mp_backlot"] = [];
	level.gfmaps["mp_backlot"]["localised_name"] = "Backlot (COD4)";
	level.gfmaps["mp_backlot"]["zone_name"] = "mp_backlot";

	level.gfmaps["mp_summit"] = [];
	level.gfmaps["mp_summit"]["localised_name"] = "Summit (Black Ops)";
	level.gfmaps["mp_summit"]["zone_name"] = "mp_summit";

	level.gfmaps["mp_betatnl"] = [];
	level.gfmaps["mp_betatnl"]["localised_name"] = "Betatnl (Custom)";
	level.gfmaps["mp_betatnl"]["zone_name"] = "mp_betatnl";

	level.gfmaps["mp_afghan"] = [];
	level.gfmaps["mp_afghan"]["localised_name"] = "Afghan (MW2)";
	level.gfmaps["mp_afghan"]["zone_name"] = "mp_afghan";
	
	level.gfmaps["mp_complex"] = [];
	level.gfmaps["mp_complex"]["localised_name"] = "Bailout (MW2)";
	level.gfmaps["mp_complex"]["zone_name"] = "mp_complex";
	
	level.gfmaps["mp_bloc"] = [];
	level.gfmaps["mp_bloc"]["localised_name"] = "Bloc (COD4)";
	level.gfmaps["mp_bloc"]["zone_name"] = "mp_bloc";
	
	level.gfmaps["mp_bog_sh"] = [];
	level.gfmaps["mp_bog_sh"]["localised_name"] = "Bog (COD4)";
	level.gfmaps["mp_bog_sh"]["zone_name"] = "mp_bog_sh";
	
	level.gfmaps["mp_abandon"] = [];
	level.gfmaps["mp_abandon"]["localised_name"] = "Carnival (MW2)";
	level.gfmaps["mp_abandon"]["zone_name"] = "mp_abandon";
	
	level.gfmaps["mp_storm_spring"] = [];
	level.gfmaps["mp_storm_spring"]["localised_name"] = "Storm Spring (IW4x)";
	level.gfmaps["mp_storm_spring"]["zone_name"] = "mp_storm_spring";
	
	level.gfmaps["mp_crash"] = [];
	level.gfmaps["mp_crash"]["localised_name"] = "Crash (COD4)";
	level.gfmaps["mp_crash"]["zone_name"] = "mp_crash";
	
	level.gfmaps["mp_crash_tropical"] = [];
	level.gfmaps["mp_crash_tropical"]["localised_name"] = "Crash: Tropical (IW4x)";
	level.gfmaps["mp_crash_tropical"]["zone_name"] = "mp_crash_tropical";
	
	level.gfmaps["mp_cross_fire"] = [];
	level.gfmaps["mp_cross_fire"]["localised_name"] = "Crossfire (COD4)";
	level.gfmaps["mp_cross_fire"]["zone_name"] = "mp_cross_fire";
	
	level.gfmaps["mp_derail"] = [];
	level.gfmaps["mp_derail"]["localised_name"] = "Derail (MW2)";
	level.gfmaps["mp_derail"]["zone_name"] = "mp_derail";
	
	level.gfmaps["mp_estate"] = [];
	level.gfmaps["mp_estate"]["localised_name"] = "Estate (MW2)";
	level.gfmaps["mp_estate"]["zone_name"] = "mp_estate";
	
	level.gfmaps["mp_estate_tropical"] = [];
	level.gfmaps["mp_estate_tropical"]["localised_name"] = "Estate: Tropical (IW4x)";
	level.gfmaps["mp_estate_tropical"]["zone_name"] = "mp_estate_tropical";
	
	level.gfmaps["mp_favela"] = [];
	level.gfmaps["mp_favela"]["localised_name"] = "Favela (MW2)";
	level.gfmaps["mp_favela"]["zone_name"] = "mp_favela";
	
	level.gfmaps["mp_fav_tropical"] = [];
	level.gfmaps["mp_fav_tropical"]["localised_name"] = "Favela: Tropical (IW4x)";
	level.gfmaps["mp_fav_tropical"]["zone_name"] = "mp_fav_tropical";
	
	level.gfmaps["mp_firingrange"] = [];
	level.gfmaps["mp_firingrange"]["localised_name"] = "Firing Range (Black Ops)";
	level.gfmaps["mp_firingrange"]["zone_name"] = "mp_firingrange";
	
	level.gfmaps["mp_bloc_sh"] = [];
	level.gfmaps["mp_bloc_sh"]["localised_name"] = "Forgotten City (COD4)";
	level.gfmaps["mp_bloc_sh"]["zone_name"] = "mp_bloc_sh";
	
	level.gfmaps["mp_cargoship_sh"] = [];
	level.gfmaps["mp_cargoship_sh"]["localised_name"] = "Freighter (COD4)";
	level.gfmaps["mp_cargoship_sh"]["zone_name"] = "mp_cargoship_sh";
	
	level.gfmaps["mp_fuel2"] = [];
	level.gfmaps["mp_fuel2"]["localised_name"] = "Fuel (MW2)";
	level.gfmaps["mp_fuel2"]["zone_name"] = "mp_fuel2";
	
	level.gfmaps["mp_highrise"] = [];
	level.gfmaps["mp_highrise"]["localised_name"] = "Highrise (MW2)";
	level.gfmaps["mp_highrise"]["zone_name"] = "mp_highrise";
	
	level.gfmaps["mp_invasion"] = [];
	level.gfmaps["mp_invasion"]["localised_name"] = "Invasion (MW2)";
	level.gfmaps["mp_invasion"]["zone_name"] = "mp_invasion";
	
	level.gfmaps["mp_checkpoint"] = [];
	level.gfmaps["mp_checkpoint"]["localised_name"] = "Karachi (MW2)";
	level.gfmaps["mp_checkpoint"]["zone_name"] = "mp_checkpoint";

	level.gfmaps["mp_killhouse"] = [];
	level.gfmaps["mp_killhouse"]["localised_name"] = "Killhouse (COD4)";
	level.gfmaps["mp_killhouse"]["zone_name"] = "mp_killhouse";
	
	level.gfmaps["mp_nuked"] = [];
	level.gfmaps["mp_nuked"]["localised_name"] = "Nuketown (Black Ops)";
	level.gfmaps["mp_nuked"]["zone_name"] = "mp_nuked";
	
	level.gfmaps["oilrig"] = [];
	level.gfmaps["oilrig"]["localised_name"] = "Oil Rig (MW2)";
	level.gfmaps["oilrig"]["zone_name"] = "oilrig";
	
	level.gfmaps["mp_overgrown"] = [];
	level.gfmaps["mp_overgrown"]["localised_name"] = "Overgrown (MW2)";
	level.gfmaps["mp_overgrown"]["zone_name"] = "mp_overgrown";
	
	level.gfmaps["mp_quarry"] = [];
	level.gfmaps["mp_quarry"]["localised_name"] = "Quarry (MW2)";
	level.gfmaps["mp_quarry"]["zone_name"] = "mp_quarry";
	
	level.gfmaps["mp_rundown"] = [];
	level.gfmaps["mp_rundown"]["localised_name"] = "Rundown (MW2)";
	level.gfmaps["mp_rundown"]["zone_name"] = "mp_rundown";
	
	level.gfmaps["mp_rust"] = [];
	level.gfmaps["mp_rust"]["localised_name"] = "Rust (MW2)";
	level.gfmaps["mp_rust"]["zone_name"] = "mp_rust";
	
	level.gfmaps["mp_rust_long"] = [];
	level.gfmaps["mp_rust_long"]["localised_name"] = "Rust: Long (IW4x)";
	level.gfmaps["mp_rust_long"]["zone_name"] = "mp_rust_long";
	
	level.gfmaps["mp_compact"] = [];
	level.gfmaps["mp_compact"]["localised_name"] = "Salvage (MW2)";
	level.gfmaps["mp_compact"]["zone_name"] = "mp_compact";
	
	level.gfmaps["mp_boneyard"] = [];
	level.gfmaps["mp_boneyard"]["localised_name"] = "Scrapyard (MW2)";
	level.gfmaps["mp_boneyard"]["zone_name"] = "mp_boneyard";
	
	level.gfmaps["mp_shipment"] = [];
	level.gfmaps["mp_shipment"]["localised_name"] = "Shipment (MW2)";
	level.gfmaps["mp_shipment"]["zone_name"] = "mp_shipment";
	
	level.gfmaps["mp_shipment_long"] = [];
	level.gfmaps["mp_shipment_long"]["localised_name"] = "Shipment: Long (IW4x)";
	level.gfmaps["mp_shipment_long"]["zone_name"] = "mp_shipment_long";
	
	level.gfmaps["mp_nightshift"] = [];
	level.gfmaps["mp_nightshift"]["localised_name"] = "Skidrow (MW2)";
	level.gfmaps["mp_nightshift"]["zone_name"] = "mp_nightshift";

	level.gfmaps["mp_storm"] = [];
	level.gfmaps["mp_storm"]["localised_name"] = "Storm (MW2)";
	level.gfmaps["mp_storm"]["zone_name"] = "mp_storm";
	
	level.gfmaps["mp_strike"] = [];
	level.gfmaps["mp_strike"]["localised_name"] = "Strike (MW2)";
	level.gfmaps["mp_strike"]["zone_name"] = "mp_strike";
	
	level.gfmaps["mp_subbase"] = [];
	level.gfmaps["mp_subbase"]["localised_name"] = "Sub Base (MW2)";
	level.gfmaps["mp_subbase"]["zone_name"] = "mp_subbase";
	
	level.gfmaps["mp_terminal"] = [];
	level.gfmaps["mp_terminal"]["localised_name"] = "Terminal (MW2)";
	level.gfmaps["mp_terminal"]["zone_name"] = "mp_terminal";

	level.gfmaps["mp_terminal_edit2"] = [];
	level.gfmaps["mp_terminal_edit2"]["localised_name"] = "Terminal Ground (MW2)";
	level.gfmaps["mp_terminal_edit2"]["zone_name"] = "mp_terminal";
	
	level.gfmaps["mp_trailerpark"] = [];
	level.gfmaps["mp_trailerpark"]["localised_name"] = "Trailer Park (MW2)";
	level.gfmaps["mp_trailerpark"]["zone_name"] = "mp_trailerpark";
	
	level.gfmaps["mp_underpass"] = [];
	level.gfmaps["mp_underpass"]["localised_name"] = "Underpass (MW2)";
	level.gfmaps["mp_underpass"]["zone_name"] = "mp_underpass";
	
	level.gfmaps["mp_vacant"] = [];
	level.gfmaps["mp_vacant"]["localised_name"] = "Vacant (COD4)";
	level.gfmaps["mp_vacant"]["zone_name"] = "mp_vacant";

	level.gfmaps["mp_brecourt"] = [];
	level.gfmaps["mp_brecourt"]["localised_name"] = "Wasteland (MW2)";
	level.gfmaps["mp_brecourt"]["zone_name"] = "mp_brecourt";
	
	level.gfmaps["mp_cargoship"] = [];
	level.gfmaps["mp_cargoship"]["localised_name"] = "Wet Work (COD4)";
	level.gfmaps["mp_cargoship"]["zone_name"] = "mp_cargoship";
}

createprimaryprogressbar2( var_0, var_1 )
{
    if ( !isdefined( var_0 ) )
        var_0 = 0;

    if ( !isdefined( var_1 ) )
        var_1 = 0;

    if ( self issplitscreenplayer() )
        var_1 += 20;

    var_2 = createbar2( ( 1.0, 1.0, 1.0 ), level.primaryprogressbarwidth, level.primaryprogressbarheight );
    var_2 setpoint( "CENTER", undefined, level.primaryprogressbarx + var_0, level.primaryprogressbary + var_1 );
    return var_2;
}


createbar2( var_0, var_1, var_2, var_3 )
{
    var_4 = newclienthudelem( self );
    var_4.x = 0;
    var_4.y = 0;
    var_4.frac = 0;
    var_4.color = var_0;
    var_4.sort = -2;
    var_4.shader = "progress_bar_fill";
    var_4 setshader( "progress_bar_fill", var_1, var_2 );
    var_4.hidden = 0;
    return var_4;
}